﻿using UnityEngine;
using UnityEditor;
using FullControl.Tx.View;



public class RandomRotationTool : EditorWindow 
{
	bool rotateY = true;
	bool worldSpaceY = true;
	float minRotationY = 0.0f;
	float maxRotationY = 360.0f;

	bool rotateX = false;
	bool worldSpaceX = false;
	float minRotationX = 0.0f;
	float maxRotationX = 360.0f;

	bool rotateZ = false;
	bool worldSpaceZ = false;
	float minRotationZ = 0.0f;
	float maxRotationZ = 360.0f;



	[MenuItem("Window/Random Rotation Tool")]
	public static void ShowWindow()
	{
		//Show existing window instance. If one doesn't exist, make one.
		EditorWindow.GetWindow(typeof(RandomRotationTool));
	}
	
	void OnGUI()
	{
		GUILayout.Label ("Random Rotation", EditorStyles.boldLabel);

		rotateY = EditorGUILayout.BeginToggleGroup ("Rotate around Y axis", rotateY);
			worldSpaceY = EditorGUILayout.Toggle ("Use world space", worldSpaceY);
			minRotationY = EditorGUILayout.FloatField ("Min Rotation Y", minRotationY);
			maxRotationY = EditorGUILayout.FloatField ("Max Rotation Y", maxRotationY);
		EditorGUILayout.EndToggleGroup ();

		rotateX = EditorGUILayout.BeginToggleGroup ("Rotate around X axis", rotateX);
			worldSpaceX = EditorGUILayout.Toggle ("Use world space", worldSpaceX);
			minRotationX = EditorGUILayout.FloatField ("Min Rotation X", minRotationX);
			maxRotationX = EditorGUILayout.FloatField ("Max Rotation X", maxRotationX);
		EditorGUILayout.EndToggleGroup ();

		rotateZ = EditorGUILayout.BeginToggleGroup ("Rotate around Z axis", rotateZ);
			worldSpaceZ = EditorGUILayout.Toggle ("Use world space", worldSpaceZ);
			minRotationZ = EditorGUILayout.FloatField ("Min Rotation Z", minRotationZ);
			maxRotationZ = EditorGUILayout.FloatField ("Max Rotation Z", maxRotationZ);
		EditorGUILayout.EndToggleGroup ();


		if(GUILayout.Button("Rotate!"))
		{
			RandomRotation ();
		}
	}

	//randomly rotates in the selected axis, one axis at a time for each object. 
	//might be faster to have it in all axis at once but dont seem to be a problem.
	void RandomRotation()
	{
		//selected object array and the length
		GameObject[] selectedObjects = Selection.gameObjects;
		int numberOfSelevtedObjects = selectedObjects.Length;

		//our 90 degree snap rotations
		int[] rotationAngles = new int[4];
		rotationAngles[0] = 0;
		rotationAngles[1] = 90;
		rotationAngles[2] = 180;
		rotationAngles[3] = 270;

		if(rotateX)
		{
			//every object that we have selected checks in X-axis
			for (int i = 0; i < numberOfSelevtedObjects; i++) 
			{
				//checks for AssetView component
				if(selectedObjects[i].GetComponent<AssetView>() != null)
				{
					//checks rotation snapping
					if(selectedObjects[i].GetComponent<AssetView>().rotationSnapping == RotationSnaps.Free || selectedObjects[i].GetComponent<AssetView>().rotationSnapping == null )    
					{
						//world or local space
						if(worldSpaceX)
						{
							selectedObjects[i].transform.Rotate ((Random.Range(minRotationX, maxRotationX)), 0.0f, 0.0f, Space.World);
						}
						else
						{
							selectedObjects[i].transform.Rotate ((Random.Range(minRotationX, maxRotationX)), 0.0f, 0.0f, Space.Self);
						}		
					}
					else if(selectedObjects[i].GetComponent<AssetView>().rotationSnapping == RotationSnaps.NinetyDegrees )
					{
						//we should not rotate snapping objects in this axis
						Debug.Log("Snap setting is set to 90 degrees, Tool did not rotate due to bad axis (X) on " + selectedObjects[i].name);
					}
					else
					{
						//if the rotation settings has been extended beyound free and 90 degrees after the tool was made
						Debug.Log("The rotation snap setting is unknown, tool did not rotate " + selectedObjects[i].name);
					}	
				}
				else //we dont have asset view script on the object
				{
					//world or local space
					if(worldSpaceX)
					{
						selectedObjects[i].transform.Rotate ((Random.Range(minRotationX, maxRotationX)), 0.0f, 0.0f, Space.World);
					}
					else
					{
						selectedObjects[i].transform.Rotate ((Random.Range(minRotationX, maxRotationX)), 0.0f, 0.0f, Space.Self);
					}	
				}
			}
		}

		if(rotateY)
		{

			//every object that we have selected checks in Y-axis
			for (int i = 0; i < numberOfSelevtedObjects; i++) 
			{
				//checks for AssetView component
				if(selectedObjects[i].GetComponent<AssetView>() != null)
				{
					//checks rotation snapping
					if(selectedObjects[i].GetComponent<AssetView>().rotationSnapping == RotationSnaps.Free)    
					{
						//world or locas space
						if(worldSpaceY)
						{
							selectedObjects[i].transform.Rotate (0.0f,(Random.Range(minRotationY, maxRotationY)), 0.0f, Space.World);
						}
						else
						{
							selectedObjects[i].transform.Rotate (0.0f,(Random.Range(minRotationY, maxRotationY)), 0.0f, Space.Self);
						}
					}
					else if(selectedObjects[i].GetComponent<AssetView>().rotationSnapping == RotationSnaps.NinetyDegrees )
					{
						int snapRotationIndex = Random.Range(0,4);
						if(rotationAngles[snapRotationIndex] >= minRotationY && rotationAngles[snapRotationIndex] <= maxRotationY)
						{
							selectedObjects[i].transform.Rotate(0.0f,(rotationAngles[snapRotationIndex]), 0.0f, Space.World);
						}
					}
					else
					{
						//if the rotation settings has been extended beyound free and 90 degrees after the tool was made
						Debug.Log("The rotation snap setting is unknown, tool did not rotate " + selectedObjects[i].name);
					}
				}
				else //we dont have asset view script on the object
				{
					//world or local space
					if(worldSpaceY)
					{
						selectedObjects[i].transform.Rotate (0.0f,(Random.Range(minRotationY, maxRotationY)), 0.0f, Space.World);
					}
					else
					{
						selectedObjects[i].transform.Rotate (0.0f,(Random.Range(minRotationY, maxRotationY)), 0.0f, Space.Self);
					}
				}
			}
		}

		if(rotateZ)
		{
			//every object that we have selected checks in Z-axis
			for (int i = 0; i < numberOfSelevtedObjects; i++) 
			{
				//checks for AssetView component
				if(selectedObjects[i].GetComponent<AssetView>() != null)
				{
					//checks rotation snapping
					if(selectedObjects[i].GetComponent<AssetView>().rotationSnapping == RotationSnaps.Free || selectedObjects[i].GetComponent<AssetView>().rotationSnapping == null )    
					{
						//world or local space
						if(worldSpaceZ)
						{
							selectedObjects[i].transform.Rotate (0.0f, 0.0f, (Random.Range(minRotationZ, maxRotationZ)), Space.World);
						}
						else
						{
							selectedObjects[i].transform.Rotate (0.0f, 0.0f, (Random.Range(minRotationZ, maxRotationZ)), Space.Self);
						}
					}
					else if(selectedObjects[i].GetComponent<AssetView>().rotationSnapping == RotationSnaps.NinetyDegrees )
					{
						//we should not rotate snapping objects in this axis
						Debug.Log("Snap setting is set to 90 degrees, Tool did not rotate due to bad axis (Z) on " + selectedObjects[i].name);
					}
					else
					{
						//if the rotation settings has been extended beyound free and 90 degrees after the tool was made
						Debug.Log("The rotation snap setting is unknown, tool did not rotate " + selectedObjects[i].name);
					}
				}
				else //we dont have asset view script on the object
				{
					//world or local space
					if(worldSpaceZ)
					{
						selectedObjects[i].transform.Rotate (0.0f, 0.0f, (Random.Range(minRotationZ, maxRotationZ)), Space.World);
					}
					else
					{
						selectedObjects[i].transform.Rotate (0.0f, 0.0f, (Random.Range(minRotationZ, maxRotationZ)), Space.Self);
					}
				}
			}
		}
		//so that the designer knows everyting is finished
		Debug.Log("Finished rotating. Thank you Rasmus, this was awesome!");
	}
}



